package PneumaticPackage
  package Pneumatic
    connector PneumaticConnector
      Modelica.Units.SI.Pressure p;
      flow Modelica.Units.SI.MassFlowRate m;
      annotation(
        Icon(graphics = {Rectangle(fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid, lineThickness = 0.5, extent = {{-100, 100}, {100, -100}})}));
    end PneumaticConnector;

    model Compressor
      PneumaticPackage.Pneumatic.PneumaticConnector x1 annotation(
        Placement(visible = true, transformation(origin = {0, 114}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {0, 110}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
      Modelica.Units.SI.Pressure p "Pressão do sistema";
      constant Modelica.Units.SI.Density d = 1.2041 "densidade do ar";
      parameter Real f "Frequência do motor em HZ";
      parameter Modelica.Units.SI.Volume dV "volume da câmara do compressor";
      parameter Real n "rendimento";
      parameter Modelica.Units.SI.Pressure Pl "Pressão máxima de operação";
    equation
      x1.p = p;
      if p > Pl then
        x1.m = 0;
      else
        x1.m = -dV*d*f*n;
      end if;
      annotation(
        Icon(graphics = {Ellipse(extent = {{-100, -100}, {100, 100}}), Polygon(origin = {-2, 60}, points = {{-38, -20}, {2, 40}, {42, -20}, {-38, -20}})}));
    end Compressor;

    model Airtank
      //..... constantes.....
      // constant Modelica.Units.SI.Pressure p0 = 101325 "pressao inicial";
      constant Modelica.Units.SI.MolarMass M = 0.02896 "massa molar do ar";
      constant Real k = 8.31 "constante universal dos gases";
      constant Modelica.Units.SI.Temperature T = 293 "temperatura em K";
      //.....parametros
      parameter Modelica.Units.SI.Volume V "volume do compartimento";
      //........Variaveis internas.....
      Modelica.Units.SI.MassFlowRate Vm "vazao em massa na entrada";
      Modelica.Units.SI.Pressure p " pressao no reservatorio";
      // .....Conectores
      PneumaticPackage.Pneumatic.PneumaticConnector x1 annotation(
        Placement(visible = true, transformation(origin = {10, -82}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {0, -90}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
      parameter Modelica.Units.SI.Pressure pi = 101325 "Pressão inicial";
      PneumaticPackage.Pneumatic.PneumaticConnector x2 annotation(
        Placement(visible = true, transformation(origin = {-6, 84}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {2, 88}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    initial equation
      pi = p;
    equation
//Vm + x1.m = 0;
      Vm = x1.m + x2.m;
      Vm = (V*M)*der(p)/(k*T);
      x1.p = p;
      x2.p = p;
//x1.p + p = 0; // Pressao manometrica
      annotation(
        Icon(graphics = {Line(origin = {40, 0}, points = {{0, 40}, {0, -40}}), Line(origin = {-40, 1}, points = {{0, 39}, {0, -41}}), Ellipse(origin = {0, 40}, extent = {{-40, -40}, {40, 40}}, endAngle = 180, closure = EllipseClosure.None), Ellipse(origin = {0, -40}, extent = {{-40, 40}, {40, -40}}, endAngle = 180, closure = EllipseClosure.None)}));
    end Airtank;

    model PressureSource
      PneumaticConnector x1 annotation(
        Placement(visible = true, transformation(origin = {0, 42}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {0, 42}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
      parameter Modelica.Units.SI.Pressure p;
    equation
      x1.p = p;
      annotation(
        Icon(graphics = {Polygon(origin = {0, -20}, points = {{-40, -20}, {0, 20}, {40, -20}, {-40, -20}}), Line(origin = {0, 20}, points = {{0, -20}, {0, 20}})}));
    end PressureSource;

    model Exhaust
      PneumaticPackage.Pneumatic.PneumaticConnector x1 annotation(
        Placement(visible = true, transformation(origin = {0, 42}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {0, 42}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    equation
      x1.p = 101325;
      annotation(
        Icon(graphics = {Polygon(origin = {0, -20}, points = {{-40, 20}, {0, -20}, {40, 20}, {-40, 20}}), Line(origin = {0, 20}, points = {{0, -20}, {0, 20}})}));
    end Exhaust;
    
    model ThreeXTwoA
      Modelica.Blocks.Interfaces.RealInput r annotation(
        Placement(visible = true, transformation(origin = {-122, -4}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-160, 0}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
      PneumaticPackage.Pneumatic.PneumaticConnector x3 annotation(
        Placement(visible = true, transformation(origin = {60, -48}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {60, -50}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
      PneumaticConnector x2 annotation(
        Placement(visible = true, transformation(origin = {18, 50}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {18, 50}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
      PneumaticPackage.Pneumatic.PneumaticConnector x1 annotation(
        Placement(visible = true, transformation(origin = {14, -58}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {20, -50}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
      Modelica.Units.SI.MassFlowRate q_ma, q_mac;
      Modelica.Units.SI.Pressure P_d, P_u;
      parameter Modelica.Units.SI.Area Amax = 0.00000085;
      Modelica.Units.SI.Area Af;
      constant Modelica.Units.SI.Temperature T = 293.15;
      constant Real B = 0.526 "critical ratio";
      // Auxiliares
      Real phi, a, b, c, z;
      Real y = 1.4, R = 287 "constante universal dos gases";
    equation
      q_mac = Af*P_u*sign(a)*sqrt(abs(a));
      a = ((2*y)/(z))*b;
      z = (y - 1)*R*T;
      b = ((phi)^(2/y)) - ((phi)^((y + 1)/y));
      q_ma = Af*P_u*sign(c)*sqrt(abs(c));
      c = (y/(R*T))*((2/(y + 1))^((y + 1)/(y - 1)));
      if P_d < P_u then
        phi = P_d/P_u;
      else
        phi = 1;
      end if;
    // por enquanto não usarei uma função do orifício de abertura da válvula, considerarei ele constante como máximo
      Af = Amax;
      if r < 0 then
    //desenergizado
        if phi > B then
          x2.m = q_mac;
          x2.p = P_u;
          x3.p = P_d;
          x1.m = 0;
          x2.m + x3.m = 0;
        else
          x2.m = q_ma;
          x2.p = P_u;
          x3.p = P_d;
          x1.m = 0;
          x2.m + x3.m = 0;
        end if;
      else
    //energizado
        if phi > B then
          x1.m = q_mac;
          x1.p = P_u;
          x2.p = P_d;
          x3.m = 0;
          x1.m + x2.m = 0;
        else
          x1.m = q_ma;
          x1.p = P_u;
          x2.p = P_d;
          x3.m = 0;
          x1.m + x2.m = 0;
        end if;
      end if;
      annotation(
        Icon(graphics = {Rectangle(lineThickness = 0.5, extent = {{-80, 40}, {80, -40}}), Line(points = {{0, 40}, {0, -40}}, thickness = 0.5), Rectangle(origin = {-110, 0}, extent = {{-30, 20}, {30, -20}}), Line(origin = {-125, 0}, points = {{-7, -20}, {5, 20}}), Line(origin = {-60, -1}, points = {{0, -39}, {0, 39}}), Polygon(origin = {-60, 30}, fillPattern = FillPattern.Solid, points = {{-12, -10}, {0, 10}, {12, -10}, {-12, -10}}), Line(origin = {20, -30}, points = {{0, -10}, {0, 10}, {-6, 10}, {6, 10}, {0, 10}}), Line(origin = {-20, -30}, points = {{0, -10}, {0, 10}, {-6, 10}, {6, 10}, {-2, 10}}), Line(origin = {40, 0}, points = {{-20, 40}, {20, -40}}), Polygon(origin = {50, -28}, rotation = 90, fillPattern = FillPattern.Solid, points = {{-12, -10}, {0, 10}, {12, -10}, {-12, -10}})}));
    end ThreeXTwoA;
    
    model FiveXTwoA
      Modelica.Blocks.Interfaces.RealInput r annotation(
        Placement(visible = true, transformation(origin = {-122, -4}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-160, 0}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
      PneumaticPackage.Pneumatic.PneumaticConnector x1 annotation(
        Placement(visible = true, transformation(origin = {24, -54}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {20, -46}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
      PneumaticPackage.Pneumatic.PneumaticConnector x2 annotation(
        Placement(visible = true, transformation(origin = {36, -18}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {20, 46}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
      PneumaticPackage.Pneumatic.PneumaticConnector x5 annotation(
        Placement(visible = true, transformation(origin = {42, -46}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {60, 46}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
      PneumaticPackage.Pneumatic.PneumaticConnector x4 annotation(
        Placement(visible = true, transformation(origin = {40, -46}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {40, -46}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
      PneumaticPackage.Pneumatic.PneumaticConnector x3 annotation(
        Placement(visible = true, transformation(origin = {62, -48}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {60, -46}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
      Modelica.Units.SI.MassFlowRate q_maA, q_macA, q_maB, q_macB;
      Modelica.Units.SI.Pressure P_dA, P_uA, P_dB, P_uB;
      Modelica.Units.SI.Area Af;
      parameter Modelica.Units.SI.Area Amax = 0.00000085;
      constant Modelica.Units.SI.Temperature T = 293.15;
      constant Real B = 0.528 "critical ratio", y = 1.4, K = 287 "constante universal dos gases";
      // Auxiliares
      Real phiA, aA, bA, cA, zA, phiB, aB, bB, cB, zB;
    equation
      q_macA = Af*P_uA*sign(aA)*sqrt(abs(aA));
      aA = ((2*y)/(zA))*bA;
      zA = (y - 1)*K*T;
      bA = ((phiA)^(2/y)) - ((phiA)^((y + 1)/y));
      q_maA = Af*P_uA*sign(cA)*sqrt(abs(cA));
      cA = (y/(K*T))*((2/(y + 1))^((y + 1)/(y - 1)));
      q_macB = Af*P_uB*sign(aB)*sqrt(abs(aB));
      aB = ((2*y)/(zB))*bB;
      zB = (y - 1)*K*T;
      bB = ((phiB)^(2/y)) - ((phiB)^((y + 1)/y));
      q_maB = Af*P_uB*sign(cB)*sqrt(abs(cB));
      cB = (y/(K*T))*((2/(y + 1))^((y + 1)/(y - 1)));
      if P_dA < P_uA then
        phiA = P_dA/P_uA;
      else
        phiA = 1;
      end if;
      if P_dB < P_uB then
        phiB = P_dB/P_uB;
      else
        phiB = 1;
      end if;
    // por enquanto não usarei uma função do orifício de abertura da válvula, considerarei ele constante como máximo
      Af = Amax;
      if r < 0 then
    //desenergizado
        x3.m = 0;
        if phiA > B then
          x2.m = q_macA;
          x2.p = P_uA;
          x1.p = P_dA;
          x2.m + x1.m = 0;
        else
          x2.m = q_maA;
          x2.p = P_uA;
          x1.p = P_dA;
          x2.m + x1.m = 0;
        end if;
        if phiB > B then
          x4.m = q_macB;
          x4.p = P_uB;
          x5.p = P_dB;
          x5.m + x4.m = 0;
        else
          x4.m = q_maB;
          x4.p = P_uB;
          x5.p = P_dB;
          x5.m + x4.m = 0;
        end if;
      else
    //energizado
        x1.m = 0;
        if phiA > B then
          x4.m = q_macA;
          x4.p = P_uA;
          x2.p = P_dA;
          x2.m + x4.m = 0;
        else
          x4.m = q_maA;
          x4.p = P_uA;
          x2.p = P_dA;
          x2.m + x4.m = 0;
        end if;
        if phiB > B then
          x5.m = q_macB;
          x5.p = P_uB;
          x3.p = P_dB;
          x5.m + x3.m = 0;
        else
          x5.m = q_maB;
          x5.p = P_uB;
          x3.p = P_dB;
          x5.m + x3.m = 0;
        end if;
      end if;
      annotation(
        Icon(graphics = {Rectangle(lineThickness = 0.5, extent = {{-80, 40}, {80, -40}}), Line(points = {{0, 40}, {0, -40}}, thickness = 0.5), Rectangle(origin = {-110, 0}, extent = {{-30, 20}, {30, -20}}), Line(origin = {-125, 0}, points = {{5, -20}, {25, 20}}), Line(origin = {-60, -1}, points = {{20, -39}, {0, 39}}), Polygon(origin = {-58, 30}, rotation = 14.03, fillPattern = FillPattern.Solid, points = {{-12, -10}, {0, 10}, {12, -10}, {-12, -10}}), Line(origin = {40, 0}, points = {{-20, 40}, {-20, -40}}), Line(origin = {-60, -30}, points = {{0, -10}, {0, 10}, {-6, 10}, {6, 10}, {2, 10}}), Line(origin = {-20, 0}, points = {{0, 40}, {0, -40}}), Polygon(origin = {-20, -30}, rotation = 180, fillPattern = FillPattern.Solid, points = {{-12, -10}, {0, 10}, {12, -10}, {-12, -10}}), Polygon(origin = {20, -30}, rotation = 180, fillPattern = FillPattern.Solid, points = {{-12, -10}, {0, 10}, {12, -10}, {-12, -10}}), Line(origin = {60.5, -30}, points = {{-0.5, -10}, {-0.5, 10}, {-6.5, 10}, {5.5, 10}}), Polygon(origin = {58, 30}, rotation = -14.03, fillPattern = FillPattern.Solid, points = {{-12, -10}, {0, 10}, {12, -10}, {-12, -10}}), Line(origin = {40, -6}, points = {{0, -34}, {20, 46}})}));
    end FiveXTwoA;
    
    model ThreeXTwoB
      Modelica.Blocks.Interfaces.RealInput r annotation(
        Placement(visible = true, transformation(origin = {-122, -4}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-160, 0}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
      PneumaticPackage.Pneumatic.PneumaticConnector x3 annotation(
        Placement(visible = true, transformation(origin = {60, -48}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {60, -50}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
      PneumaticConnector x2 annotation(
        Placement(visible = true, transformation(origin = {18, 50}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {18, 50}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
      PneumaticPackage.Pneumatic.PneumaticConnector x1 annotation(
        Placement(visible = true, transformation(origin = {14, -58}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {20, -50}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
      parameter Real Bf = 0.000002577 "constante de enchimento";
      parameter Real Be = 0.000000008387 "constante de esvaziamento";
    equation
      if (r > 0) then
    //enchendo
        if x1.p >= x2.p then
          x3.m = 0;
          x1.m + x2.m = 0;
          x1.m = Bf*sqrt((abs(x1.p - x2.p)));
        else
          x3.m = 0;
          x1.m + x2.m = 0;
          x1.m = 0;
        end if;
      else
    //esvaziando
        x1.m = 0;
        x2.m + x3.m = 0;
        x2.m = Be*(x2.p - x3.p);
      end if;
      annotation(
        Icon(graphics = {Rectangle(lineThickness = 0.5, extent = {{-80, 40}, {80, -40}}), Line(points = {{0, 40}, {0, -40}}, thickness = 0.5), Rectangle(origin = {-110, 0}, extent = {{-30, 20}, {30, -20}}), Line(origin = {-125, 0}, points = {{-7, -20}, {5, 20}}), Line(origin = {-60, -1}, points = {{0, -39}, {0, 39}}), Polygon(origin = {-60, 30}, fillPattern = FillPattern.Solid, points = {{-12, -10}, {0, 10}, {12, -10}, {-12, -10}}), Line(origin = {20, -30}, points = {{0, -10}, {0, 10}, {-6, 10}, {6, 10}, {0, 10}}), Line(origin = {-20, -30}, points = {{0, -10}, {0, 10}, {-6, 10}, {6, 10}, {-2, 10}}), Line(origin = {40, 0}, points = {{-20, 40}, {20, -40}}), Polygon(origin = {50, -28}, rotation = 90, fillPattern = FillPattern.Solid, points = {{-12, -10}, {0, 10}, {12, -10}, {-12, -10}}), Line(origin = {98.0033, -1.53443}, points = {{-18.0033, 21.5344}, {-8.0033, -18.4656}, {1.99665, 21.5344}, {11.9967, -18.4656}, {21.9967, 21.5344}})}));
    end ThreeXTwoB;
    
    model FiveXTwoB
      Modelica.Blocks.Interfaces.RealInput r annotation(
        Placement(visible = true, transformation(origin = {-122, -4}, extent = {{-20, -20}, {20, 20}}, rotation = 0), iconTransformation(origin = {-160, 0}, extent = {{-20, -20}, {20, 20}}, rotation = 0)));
      PneumaticPackage.Pneumatic.PneumaticConnector x1 annotation(
        Placement(visible = true, transformation(origin = {24, -54}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {20, -46}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
      PneumaticPackage.Pneumatic.PneumaticConnector x2 annotation(
        Placement(visible = true, transformation(origin = {36, -18}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {20, 46}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
      PneumaticPackage.Pneumatic.PneumaticConnector x5 annotation(
        Placement(visible = true, transformation(origin = {42, -46}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {60, 46}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
      PneumaticPackage.Pneumatic.PneumaticConnector x4 annotation(
        Placement(visible = true, transformation(origin = {40, -46}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {40, -46}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
      PneumaticPackage.Pneumatic.PneumaticConnector x3 annotation(
        Placement(visible = true, transformation(origin = {62, -48}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {60, -46}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
      parameter Real Bf = 0.000002577 "constante de enchimento";
      parameter Real Be = 0.000000008387 "constante de esvaziamento";
    equation
      if (r > 0) then
    //energizado
        x1.m = 0;
        x5.m + x3.m = 0;
        x5.m = Be*(x5.p - x3.p);
        if x4.p >= x2.p then
          x4.m + x2.m = 0;
          x4.m = Bf*sqrt((abs(x4.p - x2.p)));
        else
          x4.m + x2.m = 0;
          x4.m = 0;
        end if;
      else
    //Desenergizado
        x3.m = 0;
        x2.m + x1.m = 0;
        x2.m = Be*(x2.p - x1.p);
        if x4.p >= x5.p then
          x4.m + x5.m = 0;
          x4.m = Bf*sqrt((abs(x4.p - x5.p)));
        else
          x4.m + x5.m = 0;
          x4.m = 0;
        end if;
      end if;
      annotation(
        Icon(graphics = {Rectangle(lineThickness = 0.5, extent = {{-80, 40}, {80, -40}}), Line(points = {{0, 40}, {0, -40}}, thickness = 0.5), Rectangle(origin = {-110, 0}, extent = {{-30, 20}, {30, -20}}), Line(origin = {-125, 0}, points = {{-7, -20}, {5, 20}}), Line(origin = {-60, -1}, points = {{20, -39}, {0, 39}}), Polygon(origin = {-58, 30}, rotation = 14.03, fillPattern = FillPattern.Solid, points = {{-12, -10}, {0, 10}, {12, -10}, {-12, -10}}), Line(origin = {40, 0}, points = {{-20, 40}, {-20, -40}}), Line(origin = {-60, -30}, points = {{0, -10}, {0, 10}, {-6, 10}, {6, 10}, {2, 10}}), Line(origin = {-20, 0}, points = {{0, 40}, {0, -40}}), Polygon(origin = {-20, -30}, rotation = 180, fillPattern = FillPattern.Solid, points = {{-12, -10}, {0, 10}, {12, -10}, {-12, -10}}), Polygon(origin = {20, -30}, rotation = 180, fillPattern = FillPattern.Solid, points = {{-12, -10}, {0, 10}, {12, -10}, {-12, -10}}), Line(origin = {60.5, -30}, points = {{-0.5, -10}, {-0.5, 10}, {-6.5, 10}, {5.5, 10}}), Polygon(origin = {58, 30}, rotation = -14.03, fillPattern = FillPattern.Solid, points = {{-12, -10}, {0, 10}, {12, -10}, {-12, -10}}), Line(origin = {40, -6}, points = {{0, -34}, {20, 46}}), Line(origin = {98.0033, -1.53443}, points = {{-18.0033, 21.5344}, {-8.0033, -18.4656}, {1.99665, 21.5344}, {11.9967, -18.4656}, {21.9967, 21.5344}})}));
    end FiveXTwoB;

    model Actuator
      PneumaticPackage.Pneumatic.PneumaticConnector x1 annotation(
        Placement(visible = true, transformation(origin = {-92, -40}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {-91, -31}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
      PneumaticPackage.Pneumatic.PneumaticConnector x2 annotation(
        Placement(visible = true, transformation(origin = {64, -30}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {71, -31}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
      Modelica.Units.SI.Pressure Pa "pressão sobre A";
      Modelica.Units.SI.Pressure Pb "pressão sobre B";
      Modelica.Units.SI.Volume Va "volume de A";
      Modelica.Units.SI.Volume Vb "volume de B";
      Modelica.Units.SI.Area Aa "área de A";
      Modelica.Units.SI.Area Ab "área de B";
      Modelica.Units.SI.Distance y1 "posição do embolo";
      Modelica.Units.SI.Velocity y2 "velocidade do embolo";
      parameter Real B = 90 "Atrito Viscoso";
      constant Real Y = 1.4 "relação do calor específico do ar";
      constant Real R = 287 "constante universal dos gases";
      constant Modelica.Units.SI.Temperature T = 293.15 "temperatura";
      parameter Modelica.Units.SI.Diameter D "diâmetro do embolo";
      parameter Modelica.Units.SI.Diameter d "Diâmetro da haste";
      parameter Modelica.Units.SI.Mass M "massa na haste";
      parameter Modelica.Units.SI.Distance Alc "alcance";
    initial equation
      y1 = 0.001;
      Pa = 101325;
      Pb = 101325;
    equation
//------------- dinâmica das pressões ------------------
      der(Pa) = (Y/(Aa*y1))*(-y2*Pa*Aa + R*T*x1.m);
      der(Pb) = (Y/(-Ab*y1))*(y2*Pb*Ab + R*T*x2.m);
//--------------- derivadas da posição -----------------
      der(y2) = ((Aa*(Pa)/M) - (Ab*(Pb)/M) - (B*y2/M));
//------- Terminais e seus valores de pressão ----------
      Pa = x1.p;
      Pb = x2.p;
// -----------------------  áreas ----------------------
      Aa = 3.14*(D^2)/4;
      Ab = Aa - (3.14*(d^2)/4);
//-------------- volume em função da posição -----------
      Va = Aa*y1;
      Vb = (Ab)*(Alc - y1);
//--------------------- Condicionais -------------------
      if ((Alc < y1 and y2 > 0) or (y1 < 0 and y2 < 0)) then
        der(y1) = 0;
      else
        der(y1) = y2;
      end if;
      annotation(
        Icon(graphics = {Line(origin = {9.9456, 0}, points = {{70, -8}, {70, -28}, {-110, -28}, {-110, 28}, {70, 28}, {70, 8}}), Line(origin = {39.9456, -10}, points = {{60, 2}, {-104, 2}}), Line(origin = {39.9456, 10}, points = {{60, -2}, {-104, -2}}), Rectangle(origin = {-73, 0}, extent = {{-9, 28}, {9, -28}})}));
      annotation(
        Icon(graphics = {Line(origin = {39.9456, -10}, points = {{60, 2}, {-104, 2}}), Line(origin = {9.9456, 0}, points = {{70, -8}, {70, -28}, {-110, -28}, {-110, 28}, {70, 28}, {70, 8}}), Line(origin = {39.9456, 10}, points = {{60, -2}, {-104, -2}}), Rectangle(origin = {-73, 0}, extent = {{-9, 28}, {9, -28}})}));
    end Actuator;
  end Pneumatic;
  
  model Experimento1
    PneumaticPackage.Pneumatic.Airtank airtank(V = 0.0004)  annotation(
      Placement(visible = true, transformation(origin = {-14, 72}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    PneumaticPackage.Pneumatic.PressureSource pressureSource(p = 499999.9999999999)  annotation(
      Placement(visible = true, transformation(origin = {-16, 18}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    PneumaticPackage.Pneumatic.Exhaust exhaust annotation(
      Placement(visible = true, transformation(origin = {-6, 8}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    PneumaticPackage.Pneumatic.PressureSource pressureSource1(p = 499999.9999999999) annotation(
      Placement(visible = true, transformation(origin = {42, 20}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    PneumaticPackage.Pneumatic.Exhaust exhaust1 annotation(
      Placement(visible = true, transformation(origin = {50, 12}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    PneumaticPackage.Pneumatic.Airtank airtank1(V = 0.0004) annotation(
      Placement(visible = true, transformation(origin = {46, 70}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.Step step(height = 1, offset = 0, startTime = 0)  annotation(
      Placement(visible = true, transformation(origin = {-54, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.Step step1(height = 1, offset = 0, startTime = 0) annotation(
      Placement(visible = true, transformation(origin = {8, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.Step step2(height = -1, offset = 0, startTime = 0) annotation(
      Placement(visible = true, transformation(origin = {-50, -46}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    PneumaticPackage.Pneumatic.PressureSource pressureSource2(p = 499999.9999999999) annotation(
      Placement(visible = true, transformation(origin = {46, -66}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    PneumaticPackage.Pneumatic.Airtank airtank2(V = 0.0004, pi = 499999.9999999999) annotation(
      Placement(visible = true, transformation(origin = {-10, -18}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    PneumaticPackage.Pneumatic.PressureSource pressureSource3(p = 499999.9999999999) annotation(
      Placement(visible = true, transformation(origin = {-14, -64}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    PneumaticPackage.Pneumatic.Exhaust exhaust2 annotation(
      Placement(visible = true, transformation(origin = {54, -76}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    PneumaticPackage.Pneumatic.Exhaust exhaust3 annotation(
      Placement(visible = true, transformation(origin = {-6, -74}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    PneumaticPackage.Pneumatic.Airtank airtank3(V = 0.0004, pi = 499999.9999999999) annotation(
      Placement(visible = true, transformation(origin = {50, -16}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.Step step3(height = -1, offset = 0, startTime = 0) annotation(
      Placement(visible = true, transformation(origin = {12, -46}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    PneumaticPackage.Pneumatic.ThreeXTwoA threeXTwoA annotation(
      Placement(visible = true, transformation(origin = {-18, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    PneumaticPackage.Pneumatic.ThreeXTwoA threeXTwoA1 annotation(
      Placement(visible = true, transformation(origin = {-14, -46}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    PneumaticPackage.Pneumatic.ThreeXTwoB threeXTwoB annotation(
      Placement(visible = true, transformation(origin = {48, -46}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    PneumaticPackage.Pneumatic.ThreeXTwoB threeXTwoB1 annotation(
      Placement(visible = true, transformation(origin = {44, 40}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  equation
    connect(step.y, threeXTwoA.r) annotation(
      Line(points = {{-43, 40}, {-35, 40}}, color = {0, 0, 127}));
    connect(threeXTwoA.x2, airtank.x1) annotation(
      Line(points = {{-16.2, 45}, {-14.2, 45}, {-14.2, 63}}));
    connect(threeXTwoA.x1, pressureSource.x1) annotation(
      Line(points = {{-16, 35}, {-16, 21}}));
    connect(threeXTwoA.x3, exhaust.x1) annotation(
      Line(points = {{-12, 35}, {-6, 35}, {-6, 11}}));
    connect(step2.y, threeXTwoA1.r) annotation(
      Line(points = {{-39, -46}, {-31, -46}}, color = {0, 0, 127}));
    connect(threeXTwoA1.x2, airtank2.x1) annotation(
      Line(points = {{-12.2, -41}, {-10.2, -41}, {-10.2, -27}}));
    connect(pressureSource3.x1, threeXTwoA1.x1) annotation(
      Line(points = {{-14, -59.8}, {-12, -59.8}, {-12, -49.8}}));
    connect(threeXTwoA1.x3, exhaust3.x1) annotation(
      Line(points = {{-8, -51}, {-6, -51}, {-6, -71}}));
    connect(threeXTwoB.r, step3.y) annotation(
      Line(points = {{32, -46}, {24, -46}}, color = {0, 0, 127}));
    connect(airtank3.x1, threeXTwoB.x2) annotation(
      Line(points = {{50, -25}, {50, -42}}));
    connect(threeXTwoB.x1, pressureSource2.x1) annotation(
      Line(points = {{50, -51}, {46, -51}, {46, -62}}));
    connect(threeXTwoB.x3, exhaust2.x1) annotation(
      Line(points = {{54, -51}, {54, -72}}));
    connect(threeXTwoB1.r, step1.y) annotation(
      Line(points = {{28, 40}, {20, 40}}, color = {0, 0, 127}));
    connect(pressureSource1.x1, threeXTwoB1.x1) annotation(
      Line(points = {{42, 24.2}, {46, 24.2}, {46, 36.2}}));
    connect(threeXTwoB1.x3, exhaust1.x1) annotation(
      Line(points = {{50, 35}, {50, 15}}));
    connect(threeXTwoB1.x2, airtank1.x1) annotation(
      Line(points = {{45.8, 45}, {45.8, 61}}));
    annotation(
      uses(Modelica(version = "4.0.0")));
  end Experimento1;
  
  model Experimento2
    PneumaticPackage.Pneumatic.Actuator actuator(Alc = 0.45, B = 90, D = 0.025, M = 5, d = 0)  annotation(
      Placement(visible = true, transformation(origin = {19, 33}, extent = {{-11, -11}, {11, 11}}, rotation = 0)));
    PneumaticPackage.Pneumatic.Airtank airtank(V = 0.0002)  annotation(
      Placement(visible = true, transformation(origin = {8, 12}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    PneumaticPackage.Pneumatic.Airtank airtank1(V = 0.0002)  annotation(
      Placement(visible = true, transformation(origin = {16, 12}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    PneumaticPackage.Pneumatic.PressureSource pressureSource(p = 499999.9999999999)  annotation(
      Placement(visible = true, transformation(origin = {10, -30}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    PneumaticPackage.Pneumatic.Exhaust exhaust annotation(
      Placement(visible = true, transformation(origin = {6, -24}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    PneumaticPackage.Pneumatic.Exhaust exhaust1 annotation(
      Placement(visible = true, transformation(origin = {14, -24}, extent = {{-6, -6}, {6, 6}}, rotation = 0)));
    Modelica.Blocks.Sources.Pulse pulse(amplitude = 2, nperiod = -1, offset = -1, period = 4, startTime = 4, width = 50)  annotation(
      Placement(visible = true, transformation(origin = {-34, -6}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    PneumaticPackage.Pneumatic.FiveXTwoB fiveXTwoB annotation(
      Placement(visible = true, transformation(origin = {6, -6}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  equation
    connect(airtank.x2, actuator.x1) annotation(
      Line(points = {{8.12, 17.28}, {8.12, 30.28}, {9.12, 30.28}}));
    connect(airtank1.x2, actuator.x2) annotation(
      Line(points = {{16.12, 17.28}, {27.12, 17.28}, {27.12, 29.28}}));
    connect(fiveXTwoB.r, pulse.y) annotation(
      Line(points = {{-10, -6}, {-22, -6}}, color = {0, 0, 127}));
    connect(fiveXTwoB.x4, pressureSource.x1) annotation(
      Line(points = {{10, -10.6}, {10, -26.6}}));
    connect(exhaust1.x1, fiveXTwoB.x3) annotation(
      Line(points = {{14, -21.48}, {14, -16.98}, {12, -16.98}, {12, -11.48}}));
    connect(exhaust.x1, fiveXTwoB.x1) annotation(
      Line(points = {{6, -21.48}, {6, -16.98}, {8, -16.98}, {8, -11.48}}));
    connect(fiveXTwoB.x2, airtank.x1) annotation(
      Line(points = {{8, -1.4}, {8, 6.6}}));
    connect(fiveXTwoB.x5, airtank1.x1) annotation(
      Line(points = {{12, -1.4}, {16, -1.4}, {16, 5.6}}));
    annotation(
      uses(Modelica(version = "4.0.0")));
  end Experimento2;
  annotation(
    uses(Modelica(version = "4.0.0")));
end PneumaticPackage;
